/*
 * Decompiled with CFR 0.152.
 */
package betterblockentities.gui;

import betterblockentities.gui.ConfigHolder;
import betterblockentities.util.BlockEntityManager;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2587;
import net.minecraft.class_2595;
import net.minecraft.class_2611;
import net.minecraft.class_2625;
import net.minecraft.class_2627;
import net.minecraft.class_2646;
import net.minecraft.class_3721;
import net.minecraft.class_7717;
import net.minecraft.class_8172;
import org.spongepowered.include.com.google.gson.Gson;
import org.spongepowered.include.com.google.gson.GsonBuilder;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("betterblockentities.json").toFile();
    public static ConfigHolder CONFIG = new ConfigHolder();

    public static void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                CONFIG = (ConfigHolder)GSON.fromJson((Reader)reader, ConfigHolder.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ConfigManager.save();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)CONFIG, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void refreshSupportedTypes() {
        HashSet<Class<class_7717>> supported = new HashSet<Class<class_7717>>();
        if (ConfigManager.CONFIG.optimize_chests) {
            supported.add(class_2595.class);
            supported.add(class_2646.class);
            supported.add(class_2611.class);
        }
        if (ConfigManager.CONFIG.optimize_shulkers) {
            supported.add(class_2627.class);
        }
        if (ConfigManager.CONFIG.optimize_bells) {
            supported.add(class_3721.class);
        }
        if (ConfigManager.CONFIG.optimize_decoratedpots) {
            supported.add(class_8172.class);
        }
        if (ConfigManager.CONFIG.optimize_beds) {
            supported.add(class_2587.class);
        }
        if (ConfigManager.CONFIG.optimize_signs) {
            supported.add(class_2625.class);
            supported.add(class_7717.class);
        }
        BlockEntityManager.SUPPORTED_TYPES = Collections.unmodifiableSet(supported);
        ConfigHolder cfg = CONFIG;
        BlockEntityManager.chestAnims = cfg.chest_animations;
        BlockEntityManager.shulkerAnims = cfg.shulker_animations;
        BlockEntityManager.bellAnims = cfg.bell_animations;
        BlockEntityManager.potAnims = cfg.pot_animations;
        BlockEntityManager.signText = cfg.render_sign_text;
        BlockEntityManager.masterOptimize = cfg.master_optimize;
        BlockEntityManager.smoothness = cfg.smoothness_slider;
    }
}

